//
//  CMS_Utilities_ListViewController.h
//  Composr Mobile SDK
//
//  Created by Aaswini on 22/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//

import UIKit

protocol CMS_Utility_ListViewController_Delegate {
    func didSelectOption(option: String)
}

class CMS_Utilities_ListViewController: UIViewController, UITableViewDelegate, UITableViewDataSource {
    var options = [AnyObject]()
    var delegate: CMS_Utility_ListViewController_Delegate?


    override init(nibName nibNameOrNil: String!, bundle nibBundleOrNil: NSBundle!) {
        super.init(nibName: nibNameOrNil, bundle: nibBundleOrNil)
        
        // Custom initialization
    
    }

    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        self.options = ["No options to select"]
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

    @IBAction func didCancel(sender: AnyObject) {
        self.dismissViewControllerAnimated(true, completion: nil)
    }
// MARK: Table view datasource methods

    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return self.options.count
    }

    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let MyIdentifier = "MyReuseIdentifier"
        var cell = tableView.dequeueReusableCellWithIdentifier(MyIdentifier)!
        
            cell = UITableViewCell(style: .Default, reuseIdentifier: MyIdentifier)
        
        cell.textLabel!.text! = self.options[indexPath.row] as! String
        return cell
    }
// MARK: --------------
// MARK: Table view delegate methods

    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        if self.delegate != nil {
            self.delegate!.didSelectOption(self.options[indexPath.row] as! String)
        }
    }
}